/*
 * Created on Aug 20, 2003
 *
 */
package XmlCommunication;
import java.io.*;
import java.util.*;
//import org.apache.xml.*;
import org.exolab.castor.xml.XMLNaming;
import org.exolab.castor.xml.util.*;
import org.exolab.castor.xml.util.XMLClassDescriptorImpl;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import nz.co.cks.tms.xml.*;
import nz.co.cks.tms.xml.types.*;
import Data.*;
import java.math.*;

/**
 * @author student
 *This class is being used for interpreting the response xml packets 
 * 
 */


public class XmlUnmarshal {

	static ResponseGeneral rg;
	static ResponseNcb rn ;
	static ResponseEnquiryNcbAddress rena;
	static ResponseReport rr;
	static ResponseEnquiryNcbService rens;
	static ResponseEnquiryItem rei;
	
	static int ncbId;
	static String response = "";
	
	
	public static String readResponse(String input){
		try{
			
			XmlUnmarshal.rg = null;
			XmlUnmarshal.rn = null;
			XmlUnmarshal.rr = null;
			XmlUnmarshal.rens = null;
			XmlUnmarshal.rena = null;


			StringReader reader = new StringReader(input);
			System.out.println("Unmarshal read Response Started...");
			System.out.println("****INPUT XML INTO UNMARSHAL****");
			System.out.println(input);

			Unmarshaller unmarshaller = new Unmarshaller(TmsMessage.class);

			//Unmarshal the xml object
			TmsMessage tmsMessage = (TmsMessage) unmarshaller.unmarshal(reader);
			MessageAuthBlk mab = tmsMessage.getMessageAuthBlk();
			MessageTypeChoice mtc = tmsMessage.getMessageTypeChoice();
			MessageResponseBlk mrb = mtc.getMessageResponseBlk();
			ResponseGeneral[] arr = mrb.getResponseGeneral();
			if (arr.length > 0) {
				XmlUnmarshal.rg = arr[0];
				response = responseGeneral(arr[0]);
				System.out.println("Its a response General! ");
			}
			rn = mrb.getResponseNcb();
			if (rn != null) {
				rg = null;
				response = responseNcb(rn);
				System.out.println("Its a response Ncb! ");
			}
			rr = mrb.getResponseReport();
			if (rr != null) {
				response = responseReport(rr);
				System.out.println("Its a response Enquiry Ncb Address! ");
			}
			rens = mrb.getResponseEnquiryNcbService();
			if (rens != null) {
				response = responseEnquiryNcbService(rens);
				System.out.println("Its a response Enquiry Ncb Service! ");
			}
			rena = mrb.getResponseEnquiryNcbAddress();
			if (rena != null) {
				response = responseEnquiryNcbAddress(rena);
				System.out.println("Its a response Enquiry Ncb Address! ");
			}

			rei = mrb.getResponseEnquiryItem();
			if (rei != null) {
				response = responseEnquiryItem(rei);
				System.out.println("Its a response Enquiry Ncb Address! ");
			}

			System.out.println("Unmarshal read Response Finished...");
			return response;
		} catch (Exception e) {
			System.out.println("EXCEPTION! : " + e.toString());
			return response;
		}

	}
	/**
	 * This method is being used to read Ncb Service Response
	 * @param input TMS response
	 * @return String TMS reponse interpretation
	 */
	public  static String readNcbServiceResponse(String input) {

		try {

			StringReader reader = new StringReader(input);
			System.out.println("Unmarshal read ServiceResponse Started...");
			System.out.println("****INPUT XML INTO UNMARSHAL****");
			System.out.println(input);

			Unmarshaller unmarshaller =
				new Unmarshaller(TmsNcbServiceAuth.class);

			//Unmarshal the xml object
			TmsNcbServiceAuth tmsNcbServiceAuth =
				(TmsNcbServiceAuth) unmarshaller.unmarshal(reader);

			NcbService[] mab = tmsNcbServiceAuth.getNcbService();

			int ncbId = tmsNcbServiceAuth.getNcbId();
			int limit = tmsNcbServiceAuth.getNcbConnectionLimit();
			Date date = tmsNcbServiceAuth.getNcbServiceAuthDateTime();
			String comment = tmsNcbServiceAuth.getNcbServiceAuthComment();

			response = String.valueOf(ncbId);
			return response;

		} catch (Exception e) {
			System.out.println("EXCEPTION! : " + e.toString());
			response += "EXCEPTION! : " + e.toString();
			return response;
		}

	}
	/**
	 * This method is being used to read Response General 
	 * @param rg Response General
	 * @return String Response General Interpretation.
	 */
	public static String responseGeneral(ResponseGeneral rg) {
		String s = "";
		if (Integer.parseInt(rg.getCode()) != 0) {
			s = "The request was not processed because : ";
			System.out.println(
				"The request was not processed because :"
					+ rg.getDescription());
		} else {
			s = "The request was processed successfully: ";
		}
		//			System.out.println("Response General Code: "+rg.getCode());
		//			System.out.println("Response General Action String: "+rg.getActionString());
		//			
		//			System.out.println("Response General Description: "+rg.getDescription());
		//			System.out.println("Response General DateTime: "+rg.getResponseDateTime());
		//			System.out.println("Response General ExpiryDateTime: "+rg.getResponseExpiryDateTime());
		return s;

	}
	/**
	 * This method is being used read TMS response NCB
	 * @param rn Response NCB
	 * @return String 
	 */
	public  static String responseNcb(ResponseNcb rn) {
		Ncb ncb = rn.getNcb(0);
		ncbId = ncb.getNcbId();
		return "The ncbId :" + ncbId;
	}
	/**
	 * This method is being used to read TMS Response Report
	 * @param rr Response Report
	 * @return String
	 */
	public  static String responseReport(ResponseReport rr) {
		String report = rr.getReportOutput();
		return "ResponseReport output is :" + report;
	}
	/**
	 * This method is being used to read TMS ReponseEnquiryNcbService
	 * @param rens ReponseEnquiryNcbService
	 * @return String
	 */
	public  static String responseEnquiryNcbService(ResponseEnquiryNcbService rens) {
		int ncbId = rens.getNcbId();
		NcbService[] ncbService = rens.getNcbService();
		String service = ncbService.toString();
		return "Response Enquiry ncb Service :" + ncbId + " " + service;
	}
	/**
	 * This method is being used to read TMS ReponseEnquiryNcbAddress
	 * @param rn ReponseEnquiryNcbAddress
	 * @return String
	 */
	public static String responseEnquiryNcbAddress(ResponseEnquiryNcbAddress rn) {
		return "Response Enquiry ncb Address :" + ncbId;
	}
	/**
	/**
	 * This method is being used to read TMS ReponseEnquiryItem
	 * @param rei ReponseEnquiryItem
	 * @return String
	 */
	public static String responseEnquiryItem(ResponseEnquiryItem rei) {
		ItemCost[] itemCost = rei.getItemCost();
		String cost = itemCost.toString();
		int ncbId = rei.getNcbId();
		String service = rei.getServiceCode();
		return "Response Enquiry Item :" + ncbId + " " + cost + " " + service;
	}

	/**
	 * This method is being used to get the ResponseGeneral code
	 * @return String
	 */
	/********Helper Methods**********/

	public  static String getResponseGeneralCode() {
		if (rg != null)
			return rg.getCode();
		else
			return "0";

	}
	/**
	 * This method is being used to get the ResponseGeneral description.
	 * @return String
	 */
	public  static String getResponseGeneralDescription() {
		return rg.getDescription();
	}
	/**
	 * This method is being used to get NcbId
	 * @return int NcbId
	 */
	public static int getNcbId() {
		return ncbId;
	}
	/**
	 * This method is being used to get user data
	 * @param user User data
	 * @return UserData
	 */
	public  UserData getUser(UserData user) {
		if (rn != null) {
			user.setFName(rn.getNcb(0).getName());
			user.setLName(rn.getNcb(0).getNameLast());
			user.setLoginId(rn.getNcb(0).getLogin());
		}
		if (rena != null) {
			user.setContactNumber(rena.getNcbAddress(0).getFaxNumber());
			user.setMobileNumber(rena.getNcbAddress(0).getPhoneNumber());
			user.setEmailAddress(rena.getNcbAddress(0).getEmail());
		}
		return user;
	}

}
